<?php

function form_dashed_uuid($uuid) {
	if(strlen($uuid) != 32) {
		return "";
	}

	$result = "";

	$result .= substr($uuid, 0, 8);
	$result .= "-";
	$result .= substr($uuid, 8, 4);
	$result .= "-";
	$result .= substr($uuid, 12, 4);
	$result .= "-";
	$result .= substr($uuid, 16, 4);
	$result .= "-";
	$result .= substr($uuid, 20, 12);

	return $result;
}

function get_api_key($argv) {
	$dtas_cfg = null;
	$uuid = null;

	if(count($argv) < 1) {
		exit(1);
	}

	if(($dtas_cfg = new SimpleXMLElement(file_get_contents($argv[0]))) == FALSE) {
		exit(1);
	}

	// Try connecting database	
	$dbHost = $dtas_cfg->db->host;
	$dbUser = $dtas_cfg->db->username;
	$dbPassword =  $dtas_cfg->db->password;
	if(($dbconn = pg_connect("host=$dbHost dbname=dtasdb port=5432 user=$dbUser password=$dbPassword")) == FALSE) {
		exit(1);
	}

	if(($result = pg_query_params($dbconn, 'SELECT * FROM tbl_apikey', array())) == FALSE) {
        pg_close($dbconn);
		exit(1);
	}

	if(($arrResult = pg_fetch_array($result, null, PGSQL_NUM)) == FALSE) {
        pg_close($dbconn);
		exit(1);
	}

	if(count($arrResult) != 1) {
        pg_close($dbconn);
		exit(1);
	}

	echo form_dashed_uuid($arrResult[0]);

	pg_close($dbconn);
	exit(0);
}

